﻿var longTable = {
    context: $(".v-longTableCodes"),
    datatable: null,
    treeview: null,
    longTableId: null,
    dataRowTemplate: null,
    dataColumns: [],
    dataRows: [],
    initialize: function () {
        return a4.callServerMethod(a4.getAction("GetLongTableCodes", "MultiMode", "Settings"), { longTableId: longTable.longTableId },
            function (result) {
                longTable.dataRows = result.aaData;
                longTable.dataColumns = [];

                // get variable columns
                var firstRow = longTable.dataRows[0];

                for (var key in firstRow)
                {
                    if (firstRow.hasOwnProperty(key))
                        longTable.dataColumns.push(key);
                }
            });
    },
    initializeDataTable: function () {
        var toolBarItems = [];
        var contextMenuItems = [];

        if (voxco.security.has('MODIFY_LT'))
        {
            toolBarItems.push({ "Action": "addCode", "Label": resources.AddCode, "DisplayMode": dataTables.itemDisplayMode.always }, { "Action": "delete", "Label": resources.Delete });
            contextMenuItems.push({ "Action": "delete", "Label": resources.Delete });
        }

        this.datatable = $(".h-longTableCodes", this.context).a4datatable({
            serverSide: false,
            data: longTable.dataRows,
            displayColumnSelector: false,
            displaySearchBox: false,
            allowRowSelection: voxco.security.has('MODIFY_LT'),
            multiEdit: voxco.security.has('MODIFY_LT'),
            toolBarItems: toolBarItems,
            contextMenuItems: contextMenuItems,
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                if (action == "delete")
                    longTable.deleteLongTableCodes([row.ID]);
            },
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.pluck(rows, "ID");

                switch (action) {
                    case "delete":
                        longTable.deleteLongTableCodes(ids);
                        break;

                    case "addCode":
                        longTable.addLongTableRow();
                        break;
                }
            },
            ready: function (event, data) {
                $(this).a4datatable("toggleColumn", "ID", false);
            },
            rowUpdated: function (even, data) {
                if (data.fieldName.toLowerCase() == "code") {
                    $(".v-confirmButton").removeClass("disabled");
                    longTable.validateCodes();
                }
            }
        });
    },
    bindEvents: function () {
        longTable.context.on("click", ".v-confirmButton", function () {
            if (longTable.validateCodes()) {
                a4.callServerMethod(a4.getAction("UpdateLongTableCodes", "MultiMode", "Settings"),
                {
                    longTableId: longTable.longTableId,
                    entries: JSON.stringify(longTable.dataRows)
                },
                function (result) {
                    longTable.refreshDataTable();
                    modalDialog.close();
                });
            }
        });
    },
    getRowTemplate: function () {
        var row = {};
        row.New = true;

        _.each(longTable.dataColumns, function (col) {
            row[col] = "";
        });

        return row;
    },
    addLongTableRow: function () {
        var newRow = longTable.getRowTemplate();
        newRow.ID = String(parseInt(_.max(_.pluck(longTable.dataRows, "ID")), 10) + 1);

        if (isNaN(newRow.ID))
            newRow.ID = "0";

        longTable.dataRows.push(newRow);

        longTable.refreshDataTable(true);
        longTable.validateCodes();
    },
    deleteLongTableCodes: function (ids) {
        _.each(ids, function (i) {
            var row = _.find(longTable.dataRows, function (v) { return v.ID == i; });

            if (row != null)
                row.Deleted = true;
        });

        longTable.refreshDataTable();
        longTable.validateCodes();
    },
    refreshDataTable: function (setLastPage) {
        var currentPage = (setLastPage === true) ? "last" : longTable.datatable.a4datatable("getCurrentPage");

        longTable.datatable.a4datatable("option", "data", _.filter(longTable.dataRows, function (c) { return !c.Deleted; }));
        longTable.datatable.a4datatable("setCurrentPage", currentPage);

        if (setLastPage)
        {
            var container = $(".v-longTableCodes .content");
            container.scrollTop(container.prop("scrollHeight"));
        }
    },
    validateCodes: function () {
        $(".v-confirmButton").removeClass("disabled");
        var rows = longTable.datatable.a4datatable("getRowsData");
        var isValid = true;

        _.each(rows, function (c, i) {
            var cell = longTable.datatable.a4datatable("getCell", i, "Code");
            var cellNode = cell.node();

            if (longTable.isCodeDuplicate(c.Code) || !c.Code.trim()) {
                $(cellNode).addClass("error");
                isValid = false;
            }
            else {
                $(cellNode).removeClass("error");
            }
        });

        if (!isValid) 
            $(".v-confirmButton").addClass("disabled");

        return isValid;
    },
    isCodeDuplicate: function (code) {
        var isDuplicate = _.filter(longTable.dataRows, function (v) { return v.Code == code && !v.Deleted; });
        return _.size(isDuplicate) > 1;
    }
}

$(document).ready(function () {
    if (longTable.context.length > 0) {
        longTable.longTableId = $(".v-longTableId", longTable.context).val();

        $.when(longTable.initialize()).then(function () {
            longTable.initializeDataTable();
            longTable.bindEvents();
        });
    }
});